/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.regex.result;

import com.oracle.truffle.api.CallTarget;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.interop.InteropLibrary;
import com.oracle.truffle.api.library.ExportLibrary;
import com.oracle.truffle.api.library.ExportMessage;
import com.oracle.truffle.regex.result.LazyResult;

@ExportLibrary(value=InteropLibrary.class)
public final class SingleResultLazyStart
extends LazyResult {
    private int start = -1;
    private final CallTarget findStartCallTarget;

    public SingleResultLazyStart(Object input, int fromIndex, int end, CallTarget findStartCallTarget) {
        super(input, fromIndex, end);
        this.findStartCallTarget = findStartCallTarget;
    }

    @Override
    public int getStart(int groupNumber) {
        return groupNumber == 0 ? this.start : -1;
    }

    @Override
    public int getEnd(int groupNumber) {
        return groupNumber == 0 ? this.getEnd() : -1;
    }

    public boolean isStartCalculated() {
        return this.start != -1;
    }

    public int getStart() {
        return this.start;
    }

    public void setStart(int start) {
        assert (start >= 0);
        this.start = start;
    }

    public CallTarget getFindStartCallTarget() {
        return this.findStartCallTarget;
    }

    public Object[] createArgsFindStart() {
        return new Object[]{this.getInput(), this.getFromIndex(), this.getEnd()};
    }

    @Override
    @CompilerDirectives.TruffleBoundary
    public void debugForceEvaluation() {
        if (!this.isStartCalculated()) {
            this.setStart((Integer)this.findStartCallTarget.call(this.createArgsFindStart()));
        }
    }

    @CompilerDirectives.TruffleBoundary
    public String toString() {
        if (!this.isStartCalculated()) {
            this.debugForceEvaluation();
        }
        return "[" + this.start + ", " + this.getEnd() + "]";
    }

    @Override
    @CompilerDirectives.TruffleBoundary
    @ExportMessage
    public Object toDisplayString(boolean allowSideEffects) {
        if (allowSideEffects) {
            return "TRegexLazyResult" + this.toString();
        }
        return "TRegexLazyResult[" + (this.isStartCalculated() ? Integer.valueOf(this.start) : "_not computed yet_") + ", " + this.getEnd() + ']';
    }
}

